/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_12;

import java.util.*; 
import djbuch.kapitel_06.GC;
import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class DateTimeDemo extends NotesThread {

	private static final String PASSWORD = "geheim";
	private static final String HOST = null;//"www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = null;//"Thomas Ekert/DJBUCH";	//null fr lokale Session

	public static void main(String[] args) {
		DateTimeDemo dtd = new DateTimeDemo();
		dtd.start();
	}
	public void runNotes() {
		Session session = null;
		DateTime dt = null;
		DateRange dr = null;
		try {
			session=NotesFactory.createSession (HOST, USER, PASSWORD);
			dt = session.createDateTime(Calendar.getInstance());
			System.out.println ("Wechsel der GMT Zeit");
			dt.setLocalDate(2005,3,26,true);
			dt.setLocalTime(19,0,0,0);
			System.out.println (dt);
			System.out.println (dt.getGMTTime());
			for (int i = 1; i < 7; i++) {
				dt.adjustHour(2, false);				
				System.out.println ("+" + i + " h\t" + dt.getLocalTime() + " \t" + dt.getGMTTime());
			}
			System.out.println ("Wechsel der lokalen Zeit");
			dt.setLocalDate(2005,3,26);
			dt.setLocalTime(19,0,0,0);
			System.out.println (dt);
			System.out.println (dt.getGMTTime());
			for (int i = 1; i < 7; i++) {
				dt.adjustHour(2, true);				
				System.out.println ("+" + i + " h\t" + dt.getLocalTime() + " \t" + dt.getGMTTime());
			}
			dt.setLocalDate(2004,12,31);
			dt.setLocalTime(23,59,59,0);			
			System.out.println (dt);
			dt.adjustSecond(1);
			System.out.println (dt);			
			System.out.println("\n\n...");
			dt.setLocalDate(2005,06,14);
			dt.setLocalTime (12,0,0,0);
			System.out.println (dt.getDateOnly());
			System.out.println (dt.getGMTTime());
			System.out.println (dt.getLocalTime());
			System.out.println (dt.getTimeOnly());
			System.out.println (dt.getTimeZone());
			System.out.println (dt.getZoneTime() + "\n==============================\n");
			for (int i = -12; i < 13; i++) {
				dt.convertToZone(i,false);
				System.out.println ("tz " + dt.getTimeZone() + " / " + dt.getZoneTime());
				dt.convertToZone(i,false);
			}
			System.out.println("\n\n...");
			
			System.out.println (dt.getDateOnly());
			System.out.println (dt.getGMTTime());
			System.out.println (dt.getLocalTime());
			System.out.println (dt.getTimeOnly());
			System.out.println ("tz " + dt.getTimeZone());
			System.out.println (dt.getZoneTime());
			dt = session.createDateTime(Calendar.getInstance());
			dt.adjustDay(1);
			dt.setLocalTime(10,11,12,13);
			DateTime early = session.createDateTime(Calendar.getInstance());
			early.setLocalTime(13,14,15,16);
			System.out.println (dt.timeDifferenceDouble(early));
			System.out.println ("\n==============================\nDateRange:");
			DateRange dater = session.createDateRange();
			dater.setStartDateTime(dt);
			dater.setEndDateTime(early);
			System.out.println (dater.getText());
			//R7b4 -> bleibt hngen: dater.setText("Today 19:00 HST - Tomorrow 20:00");
			System.out.println ("per Text " + dater.getText());	
			System.out.println ("begin " + dater.getStartDateTime());
			dt.setAnyTime();
			dt.adjustHour(10);
			System.out.println (dt);
			System.out.println ("\n\n ...");
			dt.setLocalTime( "17.07.2005 19:03:24 CET");
			System.out.println (dt);
			International international = session.getInternational();
			System.out.println ("\n==============================\nInternational:");
			System.out.println (international.getAMString());
			System.out.println (international.getCurrencyDigits());
			System.out.println (international.getCurrencySymbol());
			System.out.println (international.getDateSep());
			System.out.println (international.getDecimalSep());
			System.out.println (international.getPMString());
			System.out.println (international.getThousandsSep());
			System.out.println (international.getTimeSep());
			System.out.println (international.getTimeZone());
			System.out.println (international.getToday());
			System.out.println (international.getTomorrow());
			System.out.println (international.getYesterday());
			System.out.println (international.isCurrencySpace());
			System.out.println (international.isCurrencySuffix());
			System.out.println (international.isCurrencyZero());
			System.out.println (international.isDateDMY());
			System.out.println (international.isDateMDY());
			System.out.println (international.isDateYMD());
			System.out.println (international.isDST());
			System.out.println (international.isTime24Hour());
			//doc.save(true,false);
		} catch (Exception e) {
			e.printStackTrace();
			System.err.println ((e instanceof NotesException?"id = " +((NotesException)e).id:""));
		} finally {
			GC.recycle(session);
		}
	}
}
